#ifndef __MT_INFO_WINDOW_H__
#define __MT_INFO_WINDOW_H__

#include "MTListWindow.h"

struct MTInfoWindowDataEntryTemplate
{
	char	title[256];
};

struct MTInfoWindowDataTemplate
{
	UInt32							numEntries;
	MTInfoWindowDataEntryTemplate	entries[0];
};

class MTInfoWindowEntry
{
	public:
		MTInfoWindowEntry()		{ divider = 0; }
		~MTInfoWindowEntry()	{ }
		
		std::string	title;
		std::string	data;
		UInt8		divider;
};

struct MTInfoWindowData
{
	std::vector <MTInfoWindowEntry>	entries;
};

class MTInfoWindow : public MTListWindow
{
	public:
						MTInfoWindow();
						~MTInfoWindow();
		
		MTWindowType	GetBaseWindowType(void)	{ return kInfoWindowType; }
		
		void			HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
		
		UInt8			IsUniqueWindow(void) { return 0; }
		
		void			ObjectUpdated(UInt32 type, UInt32 object);
		void			ObjectDeleted(UInt32 type, UInt32 object);
		
		void			GetWindowName(StringPtr theString);
		
		virtual void	RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8			SupportsMessage(UInt32 messageType, UInt32 messageData);
		
		void			AttachDataTemplate(MTInfoWindowDataTemplate * dataTemplate);
		void			SetNumEntries(UInt32 numEntries)	{ data.entries.resize(numEntries); }
		void			SetEntryData(UInt32 id, const char * buf, UInt8 redraw);
		void			SetEntryTitle(UInt32 id, const char * buf, UInt8 redraw);
		void			SetEntryDivider(UInt32 id, UInt8 divider, UInt8 redraw);
		
		void			RecalculateListSpacing(void);
		
		void			SetOwnerName(char * buf)	{ ownerName = buf; }
	
	protected:
		UInt32			GetItemWidth(void)					{ return kInfoWindowWidth; }
		UInt32			GetItemHeight(void)					{ return kInfoWindowElementHeight; }
		void			GetDefaultPosition(Point * where)	{ where->h = 6; where->v = 42; }
		UInt32			GetListLength(void)					{ return data.entries.size(); }
		UInt32			GetInitialItemsShown(void)			{ return 0x10; }
		
		UInt8			IsHorzResizable(void)				{ return 1; }
		virtual UInt8	SupportsSelection(void)				{ return 0; }
		virtual UInt8	SupportsExport(void)				{ return 0; }
		
		virtual UInt8	GetDividerStatus(UInt32 id)			{ return data.entries[id].divider; }
		
		void			DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags);
		virtual void	HandleListDoubleClick(UInt32 selection);
		
		virtual void	DoExport(void)						{ }
	
	private:
		static const UInt32		kInfoWindowWidth;
		static const UInt32		kInfoWindowElementHeight;
		static MTFontStyle		kInfoWindowFontStyle;
		static const char		kSpaceBuffer[256];
		
		std::string				ownerName;
		
		MTInfoWindowData		data;
		
		UInt32					maxItemTitleLength;
};

#endif /* __MT_INFO_WINDOW_H__ */
